<?php
	class DbMasini extends DbBase
	{ 

		/**
		 * @var int Id
		 */
		public $Id; 

		/**
		 * @var string marca
		 */
		public $marca; 

		/**
		 * @var string model
		 */
		public $model; 

		/**
		 * @var string culoare
		 */
		public $culoare; 

		/**
		 * @var \DateTime an_fabricatie
		 */
		public $an_fabricatie; 

		/**
		 * @var int serie
		 */
		public $serie; 

		/**
		 * @return String numele tabelului din db
		 */
		public static function _getTableName()
		{
			return 'masini';
		}
		
		/**
		 * @return string[] intoarce lista de coloane
		 */
		public function _getColumns()
		{
			return array('Id','marca','model','culoare','an_fabricatie','serie');
		}
		

		/* @return DbMasiniModel OR null */
		public static function QueryRow()
		{
			return parent::QueryRow();
		}

		/* @return DbMasiniModel[] */
		public static function QueryResult()
		{
			return parent::QueryResult();
		}

		/* @return DbMasiniModel[] */
		public static function QuerySql($sql)
		{
			return parent::QuerySql( $sql);
		}

		public static function query()
		{
			return new DbMasini_Queryable( static::_getTableName() );
		}

		
		public static function constructModel( $id=null)
		{
			return new DbMasini( $id);
		}
	}
	class DbMasini_Queryable extends DbQueryableBase
	{
		/* @return DbMasiniModel[] */
		public function get()
		{
			return DbMasiniModel::QueryResult();
		}

		/* @return DbMasiniModel[] */
		public function get_row()
		{
			return DbMasiniModel::QueryRow();
		}
	}
		