<?php
	class DbClienti extends DbBase
	{ 

		/**
		 * @var int Id
		 */
		public $Id; 

		/**
		 * @var string Nume
		 */
		public $Nume; 

		/**
		 * @var string Prenume
		 */
		public $Prenume; 

		/**
		 * @var string Cnp
		 */
		public $Cnp; 

		/**
		 * @var string Telefon
		 */
		public $Telefon; 

		/**
		 * @var string Email
		 */
		public $Email; 

		/**
		 * @var string TipPersoana
		 */
		public $TipPersoana; 

		/**
		 * @var string Adresa
		 */
		public $Adresa; 

		/**
		 * @var string Observatii
		 */
		public $Observatii; 

		/**
		 * @var int IdUserCreare
		 */
		public $IdUserCreare; 

		/**
		 * @var \DateTime DataCreare
		 */
		public $DataCreare; 

		/**
		 * @return String numele tabelului din db
		 */
		public static function _getTableName()
		{
			return 'clienti';
		}
		
		/**
		 * @return string[] intoarce lista de coloane
		 */
		public function _getColumns()
		{
			return array('Id','Nume','Prenume','Cnp','Telefon','Email','TipPersoana','Adresa','Observatii','IdUserCreare','DataCreare');
		}
		

		/* @return DbClientiModel OR null */
		public static function QueryRow()
		{
			return parent::QueryRow();
		}

		/* @return DbClientiModel[] */
		public static function QueryResult()
		{
			return parent::QueryResult();
		}

		/* @return DbClientiModel[] */
		public static function QuerySql($sql)
		{
			return parent::QuerySql( $sql);
		}

		public static function query()
		{
			return new DbClienti_Queryable( static::_getTableName() );
		}

		
		public static function constructModel( $id=null)
		{
			return new DbClienti( $id);
		}
	}
	class DbClienti_Queryable extends DbQueryableBase
	{
		/* @return DbClientiModel[] */
		public function get()
		{
			return DbClientiModel::QueryResult();
		}

		/* @return DbClientiModel[] */
		public function get_row()
		{
			return DbClientiModel::QueryRow();
		}
	}
		